<?php
/**
 * Project: MinervaKB.
 * Copyright: 2015-2017 @KonstruktStudio
 */

class MinervaKB_ProductEdit {
	/**
	 * Constructor
	 */
	public function __construct($deps) {
		$this->setup_dependencies($deps);

        add_action('current_screen', array($this, 'page_setup'));
        add_filter('woocommerce_product_data_tabs', array($this, 'kb_product_data_tab'));
        add_action('woocommerce_product_data_panels', array($this, 'kb_product_data_fields'));
	}

	public function page_setup() {
        $screen = get_current_screen();

        if (isset($screen) && ($screen->base == 'post' || $screen->base == 'edit') && $screen->post_type == 'product') {
            add_action('save_post', array($this, 'save_post'));
        }
    }

	/**
	 * Sets up dependencies
	 * @param $deps
	 */
	private function setup_dependencies($deps) {}

    /**
     * @param $product_data_tabs
     * @return mixed
     */
    public function kb_product_data_tab( $product_data_tabs ) {
        // KB
        $product_data_tabs['minerva-kb-tab'] = array(
            'label' => __( 'Knowledge Base', 'minerva-kb' ),
            'target' => 'minerva_kb_product_data',
        );

        return $product_data_tabs;
    }

    /**
     * See https://github.com/woothemes/woocommerce/blob/master/includes/admin/meta-boxes/class-wc-meta-box-product-data.php
     * for more examples of tab content
     * See https://github.com/woothemes/woocommerce/blob/master/includes/admin/wc-meta-box-functions.php for other built-in
     * functions you can call to output text boxes, select boxes, etc.
     */
    public function kb_product_data_fields() {
        global $woocommerce, $post;

        $settings_helper = new MKB_SettingsBuilder(array(
            'post' => true,
            'no_tabs' => true
        ));

        ?>
        <!-- id below must match target registered in above add_my_custom_product_data_tab function -->
        <div id="minerva_kb_product_data" class="panel woocommerce_options_panel">

            <?php

            $options = array(
                array(
                    'id' => 'mkb_woo_product_kb_connect_mode',
                    'type' => 'select',
                    'label' => __( 'Knowledge Base Tab Content', 'minerva-kb' ),
                    'options' => array(
                        'none' => __( 'None (hidden)', 'minerva-kb' ),
                        'articles' => __( 'Select KB Articles', 'minerva-kb' ),
                        'topic' => __( 'KB Topic', 'minerva-kb' ),
                        'tag' => __( 'KB Tag', 'minerva-kb' )
                    ),
                    'default' => 'none',
                    'description' => __( 'You can select related Knowledge Base content for this product', 'minerva-kb' )
                ),
                array(
                    'id' => 'mkb_woo_product_article_ids',
                    'type' => 'articles_list',
                    'label' => __( 'Select KB articles', 'minerva-kb' ),
                    'default' => '',
                    'dependency' => array(
                        'target' => 'mkb_woo_product_kb_connect_mode',
                        'type' => 'EQ',
                        'value' => 'articles'
                    ),
                ),
                array(
                    'id' => 'mkb_woo_product_topic_id',
                    'type' => 'select',
                    'label' => __( 'Select KB Topic', 'minerva-kb' ),
                    'options' => self::get_topics(),
                    'default' => '',
                    'dependency' => array(
                        'target' => 'mkb_woo_product_kb_connect_mode',
                        'type' => 'EQ',
                        'value' => 'topic'
                    ),
                ),
                array(
                    'id' => 'mkb_woo_product_tag_id',
                    'type' => 'select',
                    'label' => __( 'Select KB Tag', 'minerva-kb' ),
                    'options' => self::get_tags(),
                    'default' => '',
                    'dependency' => array(
                        'target' => 'mkb_woo_product_kb_connect_mode',
                        'type' => 'EQ',
                        'value' => 'tag'
                    ),
                ),
            );

            ?>
            <div class="mkb-woo-settings-content">
                <?php
                foreach ( $options as $option ):
                    $value = $option['default'];
                    $meta_key = '_' . $option['id'];

                    $meta_value = get_post_meta(get_the_ID(), $meta_key, true);

                    if ($meta_value !== false) {
                        $value = $meta_value;

                        if ($option['type'] === 'checkbox') {
                            $value = (bool)$value;
                        }
                    }

                    $settings_helper->render_option(
                        $option["type"],
                        $value,
                        $option
                    );
                endforeach;
                ?>
            </div>
        </div>
        <?php
    }

    private static function get_topics() {
        $options = array('' => __( 'Please, select topic', 'minerva-kb' ));

        $topics = get_terms( MKB_Options::option('article_cpt_category'), array(
            'hide_empty' => false,
        ) );

        if (isset($topics) && !is_wp_error($topics) && !empty($topics)) {
            foreach($topics as $item):
                $options[$item->term_id] = $item->name;
            endforeach;
        }

        wp_reset_postdata();

        return $options;
    }

    private static function get_tags() {
        $options = array('' => __( 'Please, select tag', 'minerva-kb' ));

        $topics = get_terms( MKB_Options::option('article_cpt_tag'), array(
            'hide_empty' => false,
        ) );

        if (isset($topics) && !is_wp_error($topics) && !empty($topics)) {
            foreach($topics as $item):
                $options[$item->term_id] = $item->name;
            endforeach;
        }

        wp_reset_postdata();

        return $options;
    }

	/**
	 * Saves article meta box fields
	 * @param $post_id
	 * @return mixed|void
	 */
	function save_post( $post_id ) {
	    $post_type = get_post_type($post_id);

		if ($post_type !== 'product') {
			return;
		}

		// connect mode
		update_post_meta(
			$post_id,
			'_mkb_woo_product_kb_connect_mode',
			isset($_POST['mkb_woo_product_kb_connect_mode']) ?
				$_POST['mkb_woo_product_kb_connect_mode'] :
				'none'
		);

        // Related Articles
        update_post_meta(
            $post_id,
            '_mkb_woo_product_article_ids',
            isset($_POST['mkb_woo_product_article_ids']) ?
                $_POST['mkb_woo_product_article_ids'] :
                array()
        );

        // KB Topic
        update_post_meta(
            $post_id,
            '_mkb_woo_product_topic_id',
            isset($_POST['mkb_woo_product_topic_id']) ?
                $_POST['mkb_woo_product_topic_id'] :
                ''
        );

        // KB Tag
        update_post_meta(
            $post_id,
            '_mkb_woo_product_tag_id',
            isset($_POST['mkb_woo_product_tag_id']) ?
                $_POST['mkb_woo_product_tag_id'] :
                ''
        );
	}
}
